*********************************************************************
5/4/11: ADDED SSINC, UIINC, PAWVAL, AND SSI.  USE THESE VARS AT FAMILY LEVEL
		FOR 1976-1979.  DON'T HAVE FAMILY LEVEL SSINC FOR 72-75, SO USE THE 
		PERSON LEVEL VARIABLES.  NOTE, SSI BECAME A FEDERAL PROGRAM IN 1974, IT 
		IS FIRST AVAILABLE IN CPS IN SRV YEAR 1976

* one family IN 1976 has fpersons=90 when it's actually 6, famid 1100052 so adjust based on person data
  make more adjustments in poverty_clean*;
**********************************************************************;
filename mar72 'C:\Users\jsulliv4\Documents\CPSdata\1972_Data\07563-0001-Data.txt';
filename mar73 'C:\Users\jsulliv4\Documents\CPSdata\1973_Data\07564-0001-Data.txt';
filename mar74 'C:\Users\jsulliv4\Documents\CPSdata\1974_Data\07565-0001-Data.txt';
filename mar75 'C:\Users\jsulliv4\Documents\CPSdata\1975_Data\07566-0001-Data.txt';
filename mar76 'C:\Users\jsulliv4\Documents\CPSdata\1976_Data\07700-0001-Data.txt';
filename mar77 'C:\Users\jsulliv4\Documents\CPSdata\1977_Data\07784-0001-Data.txt';
filename mar78 'C:\Users\jsulliv4\Documents\CPSdata\1978_Data\07836-0001-Data.txt';
filename mar79 'C:\Users\jsulliv4\Documents\CPSdata\1979_Data\07837-0001-Data.txt';


     %macro read(yr,dir);

           options obs=max mprint;

           data cpsdata.all&yr;
               infile &dir missover lrecl=1000;

*********************************************************************
   Reading in data from 1972 March CPS.
**********************************************************************;

        if &yr=1972 then do;
               input rectype  1 @;
				  if rectype=4 then famid=_n_;
				  retain famid;
                  if rectype=4 then input
                  ftype    27-28
				  state2   37-38
				  fpersons 53-54
				  fownu18  63-64
                  ftotval  73-78
				  ftotearn  79-84
				  fpovcut  103-108
                  famlis   109
				  htotval 91-96
			   	  hlivqrt   45-46
				  frelu18 55-56

                  @;
                 retain ftype state2 fpersons fownu18 fpovcut ftotval hlivqrt frelu18 famlis ftotearn htotval;

			if rectype=4 and ftype IN(1,2,5) then hhid=_n_;
				  retain hhid;

			if rectype in (1,2,3) then input
				 age 29-30
				 sex 32
				 race2 33
				 reorgn 197-198
				 famrel 38
				 famrel2 41-42
				 marstat 45
				 hga  57-58
				 hgc  59
				 wkswrk 131
                 hrslw   153-154
				 msupwgt 211-216
				 msupwgt2 $ 210  
				 msupwgt3 205-216 /* msupwgt is wrong becasue does not include negatives, so use msupwgt3
				 					 I set msupwgt=msupwgt3 in the poverty_clean* program */
				 rsnnotw   149      
                 wkswrk   131     
                 pertype        1
				 	  ssinc          85-90		
					  							/* NOTE: NO SSI PRE-1976 */
                      pawval		97-102
					  uiinc			103-108		/* NOTE:  THIS INCLUDES UI, WC AND VET */
                  ;

	  if rectype=4 then delete;
	  if ftype in (8,9) then delete;

	if ftype IN(5,6,7) then fpersons=1;
	if ftype IN(5,6,7) then fownu18=0;
	if ftype IN(5,6,7) then frelu18=0;
	*htotvals for individuals in group quarters are set at 99999;
	if ftype GE 7 then htotval=ftotval;

	*correct for obs where msupwgt3 is not entered correctly;
	if msupwgt3=. then msupwgt3=msupwgt*-1;

end;
  *********************************************************************
   Reading in data from 1973-1975 March CPS.
  **********************************************************************;

	 if 1973<=&yr<=1975 then do;
              input rectype  1 @;
			  if rectype=4 then famid=_n_;
				  retain famid;
                  if rectype=4 then input
                  ftype    27-28
				  fpersons 53-54
		    	  state2   37-38
			      hlivqrt   45-46
				  frelu18 55-56
				  fownu18  63-64
                  ftotval  73-78
				  ftotearn  79-84
				  fpovcut  103-108
                  famlis   109
				  htotval 91-96
                  @;
                 retain ftype fpersons fownu18 frelu18 fpovcut ftotval ftotearn famlis
						state2 hlivqrt htotval;

			if rectype=4 and ftype IN(1,2,5) then hhid=_n_;
				  retain hhid;

			if rectype in (1,2,3) then input

				 age 29-30
				 sex 32
				 race2 33
				 reorgn 197-198
				 famrel 38
				 famrel2 41-42
				 marstat 45
				 hga  57-58
				 hgc  59
				 wkswrk 131
                 hrslw   153-154
				 msupwgt 211-216
				 msupwgt2 $ 210
				 msupwgt3 205-216
				       rsnnotw   149      
                       wkswrk   131     
                      pertype        1

					  ssinc          85-90		
					  							/* NOTE: NO SSI PRE-1976 */
                      pawval		97-102
					  uiinc			103-108		/* NOTE:  THIS INCLUDES UI, WC AND VET */
                         ;

	  if rectype=4 then delete;
	  if ftype in (8,9) then delete;

	if ftype IN(5,6,7) then fpersons=1;
	if ftype IN(5,6,7) then fownu18=0;
	if ftype IN(5,6,7) then frelu18=0;
	*htotvals for individuals in group quarters are set at 99999;
	if ftype GE 7 then htotval=ftotval;

	*correct for obs where msupwgt3 is not entered correctly;
	if msupwgt3=. then msupwgt3=msupwgt*-1;

end;

*********************************************************************
   Reading in data from 1976 March CPS.  This is the first year with 
a household record, it is combined with the family record.
**********************************************************************;

        if &yr=1976 then do;
                   hhid=_n_;
                  input rectype  338 @;
                  if rectype=1 then input
               state2      53-54
			   hseq      1-6
			   hlivqrt   64-65
			   htenure   66
			   hreg 	 51
			   hpublic   67
			   hlorent   68
			   htotval   72-80

				  famid    101-108
				  fkind    109
                  ftype    110
				  fpersons 111-112
				  fownu18  253
                  ftotval  205-213
				  ftotearn  214-222
				  fpovcut  281-286
                  famlis   289
				  frelu18 265

				  fssinc	142-149
				  fssi		150-157
				  fuiinc	181-188
				  fpawval	158-165

                  @;
                 retain famid fkind ftype fpersons fownu18 fpovcut ftotval ftotearn famlis frelu18 fssinc fssi fuiinc fpawval
				 state2 hseq hlivqrt htenure hreg hpublic hlorent htotval;
                 if rectype=2 then input

                     pseq       1-6
                      ppos   	   7-8
                      hrslw   16-17
                       pemlr   15
                     refrel2         103
                      famrel          106
                       marstat         107
                       sex         108
                      race2           109
					  reorgn		  113-114
                       age         110-111
                      hga         115-116
                     hgc             117
                      msupwgt         118-128
                       rsnnotw         133
                       wkswrk          134-135
                       hrswk           136-137
                       rsnnotl         145
                      pertype         102
                       wagesal1        191-195
                       selfemp1        196-201
                       farm1           202-207

					  ssinc          208-211
                      ssi         212-215
					  pawval		216-220
					  uiinc			232-236		/* NOTE:  THIS INCLUDES UI, WC AND VET */
                       ;
              end;

*********************************************************************
   Reading in data from 1977-79 March CPS.
**********************************************************************;
       
	if 1977<=&yr<=1979 then do;
                   hhid=_n_;
                  input rectype  331 @;
                  if rectype=1 then input
                       state2      39-40
			   hseq      1-6
			   hlivqrt   58-59
			   htenure   60
			   hreg 	 37
			   hmsasz2    51
			   hpublic   61
			   hlorent   62
			   htotval   72-80
			   @;
                 retain state2 hseq hlivqrt htenure  hreg  hpublic hlorent hmsasz2 htotval;
                 if rectype=2 then input
                 famid 1-8
                  fkind 9
                  ftype 10
                   fpersons 11-12

                  fpovcut 181-186
                  ftotval  105-113
                  ftotearn  114-122
                   famlis       189
				   fownu18 153
                  frelu18 165
				  fssinc	42-49
				  fssi		50-57
				  fuiinc	81-88
				  fpawval	58-65

                   @;
                retain famid fpersons fkind ftype fpovcut ftotval  famlis fownu18 frelu18 ftotearn fssinc fssi fuiinc fpawval;

                  if rectype=3 then input
                      pseq       1-6
                      ppos   	   7-8
                      hrslw   16-17
                       pemlr   15
                     refrel2         103
                      famrel          106
                       marstat         107
                       sex         108
                      race2           109
					  reorgn		  113-114
                       age         110-111
                      hga         115-116
                     hgc             117
                      msupwgt         118-128
                       rsnnotw         133
                       wkswrk          134-135
                       hrswk           136-137
                       rsnnotl         145
                      pertype         102
                       wagesal1        191-195
                       selfemp1        196-201
                       farm1           202-207

					  ssinc          208-211
                      ssi         212-215
					  pawval		216-220
					  uiinc			232-236		/* NOTE:  THIS INCLUDES UI, WC AND VET */

                                       ;

              end;

   if &yr=1976 then do;
	  if rectype^=2  then delete;
	  if fkind=5 and age < 15 then delete;
   end;
   if 1977<=&yr<=1979 then do;
	  if rectype^=3 then delete; 
	  if fkind=5 and age < 15 then delete;
   end;

   year=&yr;
   ref_year=year-1;
 
ARRAY recode ssinc pawval uiinc;
DO OVER recode;
	IF recode=99999 THEN recode=0;
END;


if fpersons=90 then do;
  fpawval=0;
  fuiinc=0;
  fssi=0;
end;
  run;
  
   proc means;
   run;


%mend read;

%read(1972,mar72);
%read(1973,mar73);
%read(1974,mar74);
%read(1975,mar75);
%read(1976,mar76);
%read(1977,mar77);
%read(1978,mar78);
%read(1979,mar79);
